/*
 * Decompiled with CFR 0.152.
 */
package pse.core;

import apiipc.generated.enums.DeviceType;
import apiipc.generated.sim.Device;
import java.util.List;
import pse.common.NetworkConfiguration;
import pse.core.PantherResultEngine;
import pse.core.ResultEngineProcessor;
import pse.result.CalculatedObject;
import pse.result.IosLog;
import pse.result.WorkProduct;

public class WorkProductExtractor
extends ResultEngineProcessor {
    public WorkProductExtractor(PantherResultEngine pantherResultEngine) {
        super(pantherResultEngine);
    }

    protected CalculatedObject performProcess() throws Exception {
        WorkProduct workProduct = this.getResult().getOrCreateWorkProduct();
        NetworkConfiguration networkConfiguration = new NetworkConfiguration();
        workProduct.setNetworkConfiguration(networkConfiguration);
        List<Device> list = this.getPacketTracer().getAllDevices();
        if (list != null && !list.isEmpty()) {
            this.getSubmitProgress().startWorkProductExtractionConfigs(list.size());
            int n = 0;
            for (Device device : list) {
                this.addDeviceConfiguration(networkConfiguration, device);
                this.getSubmitProgress().inProcessWorkProductExtractionConfigs(++n);
            }
            this.getSubmitProgress().finishWorkProductExtractionConfigs();
        }
        IosLog iosLog = this.getPacketTracer().getIosLog(this.getSubmitProgress(), this.getStartingLog());
        workProduct.setIosLog(iosLog);
        this.getSubmitProgress().startWorkProductExtractionBytes();
        Object object = this.getPacketTracer().extractBytes();
        workProduct.setPkaContents((byte[])object);
        this.getSubmitProgress().finishWorkProductExtractionBytes();
        return workProduct;
    }

    protected void addDeviceConfiguration(NetworkConfiguration networkConfiguration, Device device) {
        if (device != null) {
            String string = device.getName();
            DeviceType deviceType = device.getType();
            if (deviceType == DeviceType.ROUTER || deviceType == DeviceType.SWITCH) {
                networkConfiguration.addDevice(string, deviceType.toString());
                networkConfiguration.addConfiguration(string, "show run", this.getPacketTracer().getRunningConfig(string));
            }
        }
    }
}

